/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.config;

import info.u_team.u_team_core.UCoreReference;
import info.u_team.u_team_core.util.ConfigValueHolder;
import info.u_team.useful_backpacks.config.CommonConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;

public class FabricCommonConfig {
    private static final FabricCommonConfig INSTANCE = new FabricCommonConfig();
    private final ConfigValueHolder<Boolean> allowStackingBackpacks;
    private final Path path = FabricLoader.getInstance().getConfigDir().resolve("usefulbackpacks.properties");
    private final Properties properties = new Properties();

    public static FabricCommonConfig getInstance() {
        return INSTANCE;
    }

    private FabricCommonConfig() {
        if (Files.exists(this.path, new LinkOption[0])) {
            this.load();
        }
        this.properties.computeIfAbsent("allowStackingBackpacks", (Function<? super Object, ?>)((Function<Object, Object>)unused -> "true"));
        this.allowStackingBackpacks = new ConfigValueHolder(() -> Boolean.valueOf(this.properties.getProperty("allowStackingBackpacks", "true")), value -> {
            this.properties.put("allowStackingBackpacks", value.toString());
            class_156.method_27958().submit(this::save);
        });
        if (!Files.exists(this.path, new LinkOption[0])) {
            this.save();
        }
    }

    private void load() {
        try (BufferedReader reader = Files.newBufferedReader(this.path, StandardCharsets.UTF_8);){
            this.properties.load(reader);
        }
        catch (IOException ex) {
            UCoreReference.LOGGER.warn("Could not read property file '" + String.valueOf(this.path.toAbsolutePath()) + "'", (Throwable)ex);
        }
    }

    private void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(this.path, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.properties.store(writer, "Configuration file for Useful Backpacks mod");
        }
        catch (IOException ex) {
            UCoreReference.LOGGER.warn("Could not read property file '" + String.valueOf(this.path.toAbsolutePath()) + "'", (Throwable)ex);
        }
    }

    public static class Impl
    extends CommonConfig {
        @Override
        public ConfigValueHolder<Boolean> allowStackingBackpacks() {
            return FabricCommonConfig.INSTANCE.allowStackingBackpacks;
        }
    }
}

